<?php require(__DIR__ . '/settings.php') ?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport" />
    <title>Kupite Hypertea po sniženoj cijeni. Cijena, recenzije. Naruči Hypertea odmah!</title>


    <meta property="og:url" content="https://prirodnolijecite.com/v3/ba/hypertea/lp/1/" />
    <meta property="og:url" content="https://prirodnolijecite.com/v3/ba/hypertea/lp/1/" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="HyperTea iframe" />
    <meta property="og:description" content="HyperTea - kupite po sniženoj cijeni iframe" />
    <meta property="og:site_name" content="HyperTea name iframe" />
    <meta property="og:image:url" content="https://prirodnolijecite.com/v3/ba/hypertea/lp/1/img/photonew.jpg" />
    <meta property="og:image:type" content="image/jpg" />
    <meta property="og:image:width" content="710" />
    <meta property="og:image:height" content="473" />

    <style>
        .input-line-item {
            flex-direction: column;
        }

        label.errorValidate {

            text-align: center;
        }

        label.errorValidate {
            display: block;
            position: static;
            background: red;
            color: white;
            font-size: 16px;
            margin-top: 3px;
            margin: 0 auto;
            padding-left: 10px;
            padding-right: 10px;
            border-radius: 5px;
            width: 50%;
        }

        .errorBorder {
            border: 2px solid red !important;
        }
    </style>

    <!-- Integration code block -->
    <?= injectCodeBlock() ?>
    <!-- Integration code block END-->

    <!-- Other imports -->
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,700&subset=latin-ext" rel="stylesheet" />
    <!-- Styles -->
    <link href="css/jquery.bxslider.css" rel="stylesheet" />
    <link href="css/style.css" rel="stylesheet" />
    <link href="css/reset.css" rel="stylesheet" />
    <link href="css/order_me.min.css" media="all" rel="stylesheet" type="text/css" />
    <!-- Scripts -->
    <script src="js/placeholders-3.0.2.min.js" type="text/javascript"></script>
    <script src="js/moment-with-locales-2.18.1.min.js" type="text/javascript"></script>
    <script src="js/dr-dtime.min.js" type="text/javascript"></script>
    <script src="js/video_avid.min.js" type="text/javascript"></script>

</head>

<body>
    <!--retarget-->
    <!--retarget-->
    <div class="main">
        <header>
            <div class="content">
                <div class="logo"><img class="logotype" src="img/lotype.png" /></div>
                <div class="reclama">
                    <ul class="soft_touch">
                        <li class="reklama_1">
                            100% <br>
                            organski
                        </li>
                        <li class="reklama_2">
                            3567 ljudi <br>
                            je naručilo danas
                        </li>
                    </ul>
                </div>
                <div class="clear"></div>
            </div>
        </header>
        <section>
            <div class="block_1">
                <div class="content">
                    <p class="bl1_title">
                        Hypertea <sup class="head"> © </sup> - pomaže normalizaciji pritisaka već od prve upotrebe.;<span style="font-size: 35px;">Ukusno, praktično i uz trajan rezultat.</span></p>
                    <div class="product">
                        <div class="sale_480">
                            <!-- Rasprodaja -->
                            <br>
                            <span> -50% </span>
                        </div>
                    </div>
                    <p class="bl1_title_after">Utiče na uzrok bolesti smanjujući rizik od moždanog udara i infarkta na nulu!</p>
                    <div class="head_form">
                        <div class="head_form_1">
                            <ul class="h_f_ul">
                                <li class="h_f_li_1">Pomaže stabilizaciji krvnog pritiska u roku od 6 sati zbog prisustva bioflavonoida</li>
                                <li class="h_f_li_2">Obnavlja tonus i elastičnost krvnih sudova kroz samo 1 tretman</li>
                                <li class="h_f_li_3">Bezbjedan za svaku dob, učinkovit u 1,2 i 3 fazi hipertenzije</li>
                            </ul>
                        </div>
                        <div class="sale_icon_wrap">
                            <img class="paced_form" src="img/ws_pack_ht3.png" />
                            <div class="sale_icon">
                                <!-- Rasprodaja -->
                                <br>
                                <span> -50% </span>
                            </div>
                        </div>
                        <div class="clear dis_mob"></div>
                        <div class="head_form_2 new_999 new_480">
                            <div class="form_content_head">
                                <div class="form_title">
                                    <p class="left_t_f">Količina robe je ograničena: <br></p>
                                    <p class="right_t_f"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                    <div class="clear"></div>
                                </div>
                                <div class="form_price">
                                    <ul class="price">
                                        <li class="price_1">
                                            Puna cijena <br>
                                            <span class="bold_s_28"><span class="x_price_previous old-priceValue"> <span class="old-priceValue"><?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?></span> </span><span class="x_currency"> </span></span>
                                        </li>
                                        <li class="price_2">
                                            Snižena cijena: <br>
                                            <span class="bold_s_28"><span class="x_price_current new-priceValue"> <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span> </span><span class="x_currency"> </span></span>
                                        </li>
                                    </ul>
                                </div>
                                <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                    <?= generateHiddenFields() ?>

                                    <div class="form_container">
                                        <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                            <?= getCountryInOption() ?>
                                        </select>
                                    </div>
                                    <div class="form_container">
                                        <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                        <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                    </div>
                                    <div class="form_container">
                                        <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                        <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                    </div>
                                    <div class="form_container">
                                        <select class="input__inner select change-package-selector2" name="quantity">
                                            <?= getPaketiInOption() ?>
                                        </select>
                                    </div>
                                    <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                    <button class="form_btn js_submit button__text">Naruči</button>
                                </form>
                            </div>
                        </div>
                        <div class="head_form_2 new_999 dis_bl_480">
                            <div class="form_content_head">
                                <div class="form_title">
                                    <p class="left_t_f">Količina robe je ograničena: <br></p>
                                    <p class="right_t_f"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                    <div class="clear"></div>
                                </div>
                                <div class="form_price">
                                    <ul class="price">
                                        <li class="price_1">
                                            Puna cijena: <br>
                                            <span class="bold_s_28"><span class="x_price_previous old-priceValue"> <?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?> </span><span class="x_currency"> </span></span>
                                        </li>
                                        <li class="price_2">
                                            Snižena cijena: <br>
                                            <span class="bold_s_28"><span class="x_price_current new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['newPrice']) ?> </span><span class="x_currency"> </span></span>
                                        </li>
                                    </ul>
                                </div>
                                <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                    <?= generateHiddenFields() ?>
                                    <div class="form_container">
                                        <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                            <?= getCountryInOption() ?>
                                        </select>
                                    </div>
                                    <div class="form_container">
                                        <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                        <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                    </div>
                                    <div class="form_container">
                                        <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                        <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                    </div>
                                    <div class="form_container">
                                        <select class="input__inner select change-package-selector2" name="quantity">
                                            <?= getPaketiInOption() ?>
                                        </select>
                                    </div>
                                    <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                    <button class="form_btn js_submit button__text">Naruči</button>
                                </form>
                            </div>
                            <img class="arrow_form" src="img/arrow.png" /><img class="pacet_fomr_480" src="img/ws_pack_ht3_240.png" />
                            <div class="clear"></div>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            <div class="block_2">
                <div class="content">
                    <div class="bl2_content">
                        <p class="bl_2_title">
                            Pregledajte se! <br>
                            Imate li bar jedan od sljedećih simptoma?
                        </p>
                        <div class="content_bl2">
                            <ul class="bl2_content1">
                                <li class="bl_2_li_content_left_1"><span> Glavobolja </span></li>
                                <li class="bl_2_li_content_left_2"><span> Pojačan srčani ritam </span></li>
                                <li class="bl_2_li_content_left_3"><span> Crne tačke pred očima (koje lebde) </span></li>
                                <li class="bl_2_li_content_left_4"><span> Hronični umor </span></li>
                                <li class="bl_2_li_content_left_5"><span> Apatija, iritacija, pospanost </span></li>
                            </ul>
                            <ul class="bl2_content2 bl2_content2_240">
                                <li class="bl_2_li_content_right_1"><span> Edem na licu </span></li>
                                <li class="bl_2_li_content_right_2"><span> Zamagljen vid </span></li>
                                <li class="bl_2_li_content_right_3"><span> Utrnuli i hladni prsti </span></li>
                                <li class="bl_2_li_content_right_4"><span> Prekomjerno znojenje </span></li>
                                <li class="bl_2_li_content_right_5"><span> Nagle promjene pritiska </span></li>
                            </ul>
                            <div class="clear"></div>
                        </div>
                        <div class="after_ul_bl2">
                            <p class="title_after_ul_bl2">U PITANJU JE HIPERTENZIJA!</p>
                            <p class="you_mast_know">
                                Važno! <br>
                                U 67% slučajeva u Bosni i Hercegovini, pacijenti sa hipertenzijom uopće nisu svjesni da su bolesni.
                            </p>
                        </div>
                        <img class="men" src="img/men.png" />
                    </div>
                </div>
            </div>
            <div class="block_3">
                <div class="content">
                    <p class="bl3_title">Zbog čega je hipertenzija opasna?</p>
                    <!-- <img class="wiki" src="img/wiki.png" /> -->
                    <p class="wiki_after_title">
                        Posljedice visokog krvnog pritiska su opasnije od onkoloških bolesti i tuberkuloze zajedno. 89% slučajeva hipertenzije završi infarktom. Dolazi do pojave tromboze u krvnim sudovima. Rizik od izlivanja krvi u
                        mozak i pojave moždanog udara je veliki.
                    </p>
                    <p class="wiki_after_content">
                        Pušenje, alkohol, neuhranjenost, sjedilački način života, stres i i visok nivo holesterola čine posljedice naročito opasnim. Ljudi sa viškom kilograma pate od hipertenzije 3-4 puta češće nego ljudi sa normalnom težinom.
                    </p>
                    <p class="you_mast_know1">
                        VAŽNO! <br>
                        Hipertenzija je bolest koja brzo napreduje. Jedan od pet pacijenata se svakodnevno suočava sa rizikom od smrtnog ishoda. Počnite liječenje odmah i ne prepuštajte svoje zdravlje slučaju.
                    </p>
                </div>
            </div>
            <div class="bl_4">
                <div class="content">
                    <p class="bl4_title">Epohalno otkriće naučnika</p>
                    <p class="bl4_content">
                        Bosanskohercegovačkim naučnicima iz Nacionalnog centra za flebologiju bilo je potrebno 8 godina da dizajniraju ovaj profilaktičko-terapeutski dodatak. Otkriće godine je nominovano za međunarodnu nagradu Fondacije
                        Gairdner. Višestruki testovi su dokazali djelotvornost ovog dodatka prehrani što je akademicima obezbijedilo sve potrebne dozvole, certifikate kvaliteta i podršku vlasti.
                    </p>
                </div>
            </div>
            <div class="bl_5 dis_dec">
                <div class="content">
                    <p class="bl5_title">Hypertea uklanja 5 osnovnih uzroka hipertenzije</p>
                    <ul class="ul_bl5">
                        <li class="bl5_li li_bl5_1">
                            <span class="regular_ul"> Preopterećen živčani sistem (stres, nesanica itd.) </span><br>
                            Hypertea ublažava osjećaj anksioznosti jer sadrži korijen valerijane i srčenicu.
                        </li>
                        <li class="bl5_li li_bl5_2">
                            <span class="regular_ul"> Toksine u krvnim sudovima </span><br>
                            Hypertea poboljšava funkciju srca, čisti krvne sudove od nakupljenog otpada zahvaljujući bioflavonoidima dobijenim iz zelene kafe i gloga.
                        </li>
                        <li class="bl5_li li_bl5_3">
                            <span class="regular_ul"> Varikozitet i trombozu </span><br>
                            Hypertea poboljšava vensku cirkulaciju, razgrađuje ugruške i ojačava zidove krvnih sudova jer sadrži koncentrirane tučkove cvijeta poznatog kao hmelj (Humulus lupulus).
                        </li>
                        <div class="clear"></div>
                    </ul>
                    <div class="clear"></div>
                    <ul class="ul_bl5_1">
                        <li class="bl5_li li_bl5_4">
                            <span class="regular_ul"> Povećan nivo šećera u krvi </span><br>
                            Hypertea smanjuje količinu šećera u krvi, sprječava dijabetes zahvaljujući ekstraktima origana i preslice.
                        </li>
                        <li class="bl5_li li_bl5_5">
                            <span class="regular_ul"> Prekomjernu težinu </span><br>
                            Hypertea potiče mršavljenje, pojačava metabolizam i funkciju bubrega zahvaljujući ekstraktu matičnjaka.
                        </li>
                        <div class="clear"></div>
                    </ul>
                    <div class="clear"></div>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="bl_5 dis_mob">
                <div class="content">
                    <p class="bl5_title">A Hypertea <sup class="sup_f_size"> © </sup> megszűnteti a magas vérnyomás kialakulásának 5 legfőbb okait.</p>
                    <ul class="ul_bl5">
                        <li class="bl5_li li_bl5_1">
                            <span class="regular_ul"> Preopterećen živčani sistem (stres, nesanica itd.) </span><br>
                            Hypertea ublažava osjećaj anksioznosti jer sadrži korijen valerijane i srčenicu.
                        </li>
                        <li class="bl5_li li_bl5_2">
                            <span class="regular_ul"> Toksine u krvnim sudovima </span><br>
                            Hypertea poboljšava funkciju srca, čisti krvne sudove od nakupljenog otpada zahvaljujući bioflavonoidima dobijenim iz zelene kafe i gloga.
                        </li>
                        <div class="clear"></div>
                    </ul>
                    <ul class="ul_bl5">
                        <li class="bl5_li li_bl5_3">
                            <span class="regular_ul"> Varikozitet i trombozu </span><br>
                            Hypertea poboljšava vensku cirkulaciju, razgrađuje ugruške i ojačava zidove krvnih sudova jer sadrži koncentrirane tučkove cvijeta poznatog kao hmelj (Humulus lupulus).
                        </li>
                        <li class="bl5_li li_bl5_4">
                            <span class="regular_ul"> Povećan nivo šećera u krvi </span><br>
                            Hypertea smanjuje količinu šećera u krvi, sprječava dijabetes zahvaljujući ekstraktima origana i preslice.
                        </li>
                        <div class="clear"></div>
                    </ul>
                    <div class="clear"></div>
                    <ul class="ul_bl5_1">
                        <li class="bl5_li li_bl5_5">
                            <span class="regular_ul"> Prekomjernu težinu </span><br>
                            Hypertea potiče mršavljenje, pojačava metabolizam i funkciju bubrega zahvaljujući ekstraktu matičnjaka.
                        </li>
                        <div class="clear"></div>
                    </ul>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="bl_6">
                <div class="content">
                    <div class="bl6_content">
                        <div class="bl_6_txt">
                            <p class="title_bl_6">Mišljenje stručnjaka</p>
                            <p class="content_bl_6">
                                Potvrđujem! <br class="dsn_240" />
                                Glavni borac protiv hipertenzije su flavonoidi. Mogu se dobiti samo iz zelenog čaja i gloga. Nalaze se u skoro svim lijekovima protiv hipertenzije. <br class="dsn_240" />
                                Ali! Njihova koncentracija u većini proizvoda je zanemariva! <br>
                                Zato djelovanje možete čekati i nekoliko godina. Zasigurno znam da je jedini lijek koji obiluje bioflavonoidima Hypertea. Vidio sam njegovu formulu i zaključke neovisnih stručnjaka i uglednih ljudi. Ovaj
                                dodatak prehrani preporučujem pacijentima i prekorim ih ako počnu samoliječenje i uzimaju nešto što "im je prijatelj savjetovao", "su pročitali na internetu", "čuli na TV-u". <br class="dsn_240" />
                                To je pogrešno! Protiv hipertenzije se trebate boriti samo sigurnim metodama! Onima u koje vjeruju doktori i koje će učiniti da vaša bolest zauvijek nestane.
                            </p>
                            <p class="doctor_bl_6">
                                Doktorernativne medicine;<br>
                                Specijalista Milan Johnson</p>
                        </div>
                        <img class="doctor" src="img/expert.png" />
                    </div>
                </div>
            </div>
            <div class="bl_7">
                <div class="content">
                    <div class="bl_7_content dis_dec">
                        <div class="head_form form_content">
                            <div class="this_form_left">
                                <div class="wrap_sale_1000">
                                    <!-- Rasprodaja -->
                                    <br>
                                    <span> -50% </span>
                                </div>
                                <div class="form_price">
                                    <div class="form_title1">
                                        <p class="left_t_f1">Količina robe je ograničena: <br></p>
                                        <p class="right_t_f1"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                        <div class="clear"></div>
                                    </div>
                                    <ul class="price form_price">
                                        <li class="price_1 pr_form1">
                                            Puna cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_previous old-priceValue"> <?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?> </span><span class="x_currency"> </span></span>
                                        </li>
                                        <li class="price_2 pr_form1">
                                            Snižena cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_current new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['newPrice']) ?> </span><span class="x_currency"> </span></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="paced_fomr_pac"><img class="fomr_paced" src="img/product_form.png" /></div>
                            <div class="head_form_2">
                                <div class="form_content_head form_co_head_1">
                                    <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                        <?= generateHiddenFields() ?>

                                        <div class="form_container">
                                            <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                                <?= getCountryInOption() ?>
                                            </select>
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                            <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                            <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                        </div>
                                        <div class="form_container">
                                            <select class="input__inner select change-package-selector2" name="quantity">
                                                <?= getPaketiInOption() ?>

                                            </select>
                                        </div>
                                        <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                        <button class="form_btn js_submit button__text">Naruči</button>
                                    </form>
                                </div>
                                <ul class="sec_data_base sec_data_base1">
                                    <li>A személyes adatait bizalmasan kezeljük</li>
                                </ul>
                                <img class="arrow_form" src="img/arrow.png" />
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>
                    <div class="head_form_2 new_999 dis_mob">
                        <div class="wrap_sale_1000">
                            <!-- Rasprodaja -->
                            <br>
                            <span> -50% </span>
                        </div>
                        <div class="form_content_head">
                            <div class="form_title">
                                <p class="left_t_f">
                                    A készlet mennyisége <br>
                                    korlátozott: <br>
                                </p>
                                <p class="right_t_f"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                <div class="clear"></div>
                            </div>
                            <div class="form_price1 pr_left">
                                <ul class="price">
                                    <li class="price_1">
                                        Puna cijena: <br>
                                        <span class="bold_s_28"><span class="x_price_previous old-priceValue"> <?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?> </span><span class="x_currency"> </span></span>
                                    </li>
                                    <li class="price_2">
                                        Snižena cijena: <br>
                                        <span class="bold_s_28"><span class="x_price_current new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['newPrice']) ?> </span><span class="x_currency"> </span></span>
                                    </li>
                                </ul>
                            </div>
                            <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                <?= generateHiddenFields() ?>
                                <div class="form_container">
                                    <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                        <?= getCountryInOption() ?>
                                    </select>
                                </div>
                                <div class="form_container">
                                    <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                    <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                </div>
                                <div class="form_container">
                                    <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                    <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                </div>
                                <div class="form_container">
                                    <select class="input__inner select change-package-selector2" name="quantity">
                                        <?= getPaketiInOption() ?>
                                    </select>
                                </div>
                                <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>

                                <button class="form_btn js_submit button__text">Naruči</button>
                            </form>
                        </div>
                        <ul class="sec_data_base">
                            <li>A személyes adatait bizalmasan kezeljük</li>
                        </ul>
                        <img class="arrow_form" src="img/arrow.png" /><img class="pacet_fomr_480" src="img/ws_pack_ht3_240.png" />
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            <div class="bl_8">
                <div class="content">
                    <p class="bl8_title">
                        Djelotvornost preparata Hypertea <sup class="sup_f_size"> © </sup> dokazana je kroz <br>
                        razna ispitivanja
                    </p>
                    <div class="div_bl8">
                        <div class="bl8_txt">
                            <p class="bl_8_txt_content">
                                Kliničke potvrde su sprovedene u bolnici u Tuzli 2011. godine. Dvije grupe volontera su učestvovale u kliničkom ispitivanju koje je trajalo 25 dana.
                                <br class="dis_bl_480_not" />
                                <br>
                                Prva grupa - muškarci i žene od 28-80 godina starosti sa hipertenzijom koji su uzimali Hypertea i druga grupa - muškarci i žene sličnog stanja koji su uzimali placebo. <br class="dis_bl_480_not" />
                                Rezultati istraživanja
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bl_9">
                <div class="content">
                    <p class="bl9_title">Rezultati istraživanja</p>
                    <div class="div_bl9">
                        <div class="bl9_left">
                            <p class="title_fl_bl9">PLACEBO</p>
                            <img class="people" src="img/peaple_left.png" />
                            <table>
                                <tr>
                                    <td class="td_left">
                                        Normaliziranje <br>
                                        arterijskog pritiska
                                    </td>
                                    <td class="td_right td_one">1%</td>
                                </tr>
                                <tr>
                                    <td class="td_left td_2">Uklanjanje venske tromboze</td>
                                    <td class="td_right td_right td_2">0%</td>
                                </tr>
                                <tr>
                                    <td class="td_left td_3">Uklanjanje aritmije</td>
                                    <td class="td_right td_3">2%</td>
                                </tr>
                            </table>
                        </div>
                        <div class="bl9_right">
                            <p class="title_fl_bl9">Hypertea <sup class="sup_f_size"> © </sup></p>
                            <img class="people" src="img/people_right.png" />
                            <table>
                                <tr>
                                    <td class="td_left">
                                        Normaliziranje <br>
                                        arterijskog pritiska
                                    </td>
                                    <td class="td_right td_one">100%</td>
                                </tr>
                                <tr>
                                    <td class="td_left td_2">Uklanjanje venske tromboze</td>
                                    <td class="td_right td_right td_2">90%</td>
                                </tr>
                                <tr>
                                    <td class="td_left td_3">Uklanjanje aritmije</td>
                                    <td class="td_right td_3">99%</td>
                                </tr>
                            </table>
                        </div>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            <div class="bl_10">
                <div class="content">
                    <p class="bl10_title">Komentari ljudi koji su zadovoljni djelovanjem proizvoda Hypertea <sup class="sup_f_size"> © </sup></p>
                    <ul class="bxslider">
                        <li>
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_1.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Shvatila sam da povišen pritisak dovodi do ishemijskog moždanog udara - infarkta mozga - pošto sam vidjela kako se to dogodilo mojoj sestri. Doktori su joj spasili život, ali nije se u potpunosti
                                        oporavila. Kada sam se ja po prvi put suočila s ovom bolešću, već sam bila svjesna nekih trikova i znala sam da treba tražiti biljne preparate. Moja doktorica, mudra žena, propisala mi je
                                        Hypertea. Zahvalna sam joj. Prošle su 4 godine i više nemam hipertenziju. Sad sam potpuno zdrava osoba koja se ne boji infarkta ili moždanog udara. Brinite se o svome zdravlju!
                                    </p>
                                    <p class="bx__content-author">Belma Tahirović, 61 godina, Sarajevo</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_2.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Prije nekoliko godina išla sam na liječenje u Tuzlu. Tamo su sprovodili istraživanje o novom preparatu protiv hipertenzije. Naravno da sam se bojala. Ali šta sam drugo mogla uraditi? Nijedan drugi
                                        lijek mi nije pomagao, pa sam odlučila probati. Srećom, bila sam u grupi koja je dobijala Hypertea, a ne placebo. Nakon dva sata, pritisak mi se normalizirao. Postupno sam se počela osjećati mnogo
                                        bolje! Mnogo mi je drago što sam učestvovala u istraživanju ovog lijeka. Moj pritisak je sad u redu.
                                    </p>
                                    <p class="bx__content-author">Lejla Bećirović, 47 godina, Bihać</p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_3.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Imam 51 godinu. Prije tri godine sam dobio dijagnozu hipertenzije u našoj bolnici. Šum na srcu i tako dalje. Patio sam, ali ništa nisam uradio povodom toga. Prije šest mjeseci, sudeći po svim
                                        znacima, imao sam mikro moždani udar. Onda sam se uspaničio, ali sam odbio piti pilule koje su mi propisali. Na sreću, naišao sam na starog prijatelja koji mi je predložio Hypertea. Sad, kao što
                                        možete pogoditi, me NIŠTA ne muči. Pritisak mi je normalan, zdrav sam kao dren!
                                    </p>
                                    <p class="bx__content-author">Abdulah Sijarić, 51 godina, Zenica</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="slider_for_mobile">
                <h2>Komentari ljudi koji su zadovoljni djelovanjem proizvoda Hypertea <sup class="sup_f_size"> © </sup></h2>
                <div id="slider-container">
                    <ul class="slides">
                        <li class="slides-item">
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_1.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Shvatila sam da povišen pritisak dovodi do ishemijskog moždanog udara - infarkta mozga - pošto sam vidjela kako se to dogodilo mojoj sestri. Doktori su joj spasili život, ali nije se u potpunosti
                                        oporavila. Kada sam se ja po prvi put suočila s ovom bolešću, već sam bila svjesna nekih trikova i znala sam da treba tražiti biljne preparate. Moja doktorica, mudra žena, propisala mi je
                                        Hypertea. Zahvalna sam joj. Prošle su 4 godine i više nemam hipertenziju. Sad sam potpuno zdrava osoba koja se ne boji infarkta ili moždanog udara. Brinite se o svome zdravlju!
                                    </p>
                                    <p class="bx__content-author">Belma Tahirović, 61 godina, Sarajevo</p>
                                </div>
                            </div>
                        </li>
                        <li class="slides-item">
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_2.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Prije nekoliko godina išla sam na liječenje u Tuzlu. Tamo su sprovodili istraživanje o novom preparatu protiv hipertenzije. Naravno da sam se bojala. Ali šta sam drugo mogla uraditi? Nijedan drugi
                                        lijek mi nije pomagao, pa sam odlučila probati. Srećom, bila sam u grupi koja je dobijala Hypertea, a ne placebo. Nakon dva sata, pritisak mi se normalizirao. Postupno sam se počela osjećati mnogo
                                        bolje! Mnogo mi je drago što sam učestvovala u istraživanju ovog lijeka. Moj pritisak je sad u redu.
                                    </p>
                                    <p class="bx__content-author">Lejla Bećirović, 47 godina, Bihać</p>
                                </div>
                            </div>
                        </li>
                        <li class="slides-item">
                            <div class="bx__inner">
                                <div class="bx__img-container"><img src="img/otziv_3.png" /></div>
                                <div class="bx__content">
                                    <p class="bx__content-info">
                                        Imam 51 godinu. Prije tri godine sam dobio dijagnozu hipertenzije u našoj bolnici. Šum na srcu i tako dalje. Patio sam, ali ništa nisam uradio povodom toga. Prije šest mjeseci, sudeći po svim
                                        znacima, imao sam mikro moždani udar. Onda sam se uspaničio, ali sam odbio piti pilule koje su mi propisali. Na sreću, naišao sam na starog prijatelja koji mi je predložio Hypertea. Sad, kao što
                                        možete pogoditi, me NIŠTA ne muči. Pritisak mi je normalan, zdrav sam kao dren!
                                    </p>
                                    <p class="bx__content-author">Abdulah Sijarić, 51 godina, Zenica</p>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <!-- <ul class="buttons">
                            <li class="prev"><img src="img/prev.png"/></li>
                            <li class="next"><img src="img/next.png"/></li>
                            </ul> -->
                </div>
            </div>
            <!-- //slider -->
            <div class="bl_11">
                <div class="content">
                    <div class="bl_11_content">
                        <p class="bl_11_title">Pogodnosti preparata Hypertea <sup class="f_s_240"> © </sup></p>
                        <ul class="ul_bl11 clearfix">
                            <li class="li_bl11_1">
                                <span class="bold"> Brza pomoć </span><br>
                                Već u prvih 6 sati nakon uzimanja, pritisak će se normalizirati!
                                <div class="clear"></div>
                            </li>
                            <li class="li_bl11_2">
                                <span class="bold"> Ne uzrokuje nagle skokove i padove pritiska. </span><br>
                                Regulira ispravno funkcioniranje srca.
                                <div class="clear"></div>
                            </li>
                            <li class="li_bl11_3">
                                <span class="bold"> Sveobuhvatno poboljšanje zdravstvenog stanja. </span><br>
                                Uklanjanje angine pectoris, aritmije, neuroze, poboljšanje pamćenja, vraćanje sposobnosti govora i kretanja nakon moždanog udara.
                                <div class="clear"></div>
                            </li>
                            <li class="li_bl11_4">
                                <span class="bold"> Djelotvorni rezultat bez neželjenih posljedica. </span><br>
                                Žive biljne ćelije se potpuno slažu s ćelijama ljudskog tijela
                                <div class="clear"></div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="bl_12">
                <div class="content">
                    <div class="bl12_frame">
                        <p class="bl_12_frame_title">Način upotrebe:</p>
                        <p class="bl_12_frame_content">Prelijte 1 čajnu kašiku čaja s 200 ml vode i prokuhajte. Dobijeni napitak procijedite. Piti 3 puta dnevno poslije obroka bez dodavanja šećera.</p>
                        <div class="wrap_woman"><img class="women d_n_48_0" src="img/women.png" /></div>
                    </div>
                </div>
                <img class="women d_b_48_0" src="img/women_2.png" />
            </div>
            <div class="bl_7 bl_16">
                <div class="content">
                    <div class="bl_7_content dis_dec">
                        <div class="head_form form_content">
                            <div class="this_form_left">
                                <div class="wrap_sale_1000">
                                    <!-- Rasprodaja -->
                                    <br>
                                    <span> -50% </span>
                                </div>
                                <div class="form_price">
                                    <div class="form_title1">
                                        <p class="left_t_f1">Količina robe je ograničena: <br></p>
                                        <p class="right_t_f1"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                        <div class="clear"></div>
                                    </div>
                                    <ul class="price form_price">
                                        <li class="price_1 pr_form1">
                                            Puna cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_previous old-priceValue"> <?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?> </span></span>
                                        </li>
                                        <li class="price_2 pr_form1">
                                            Snižena cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_current new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['newPrice']) ?> </span></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="paced_fomr_pac"><img class="fomr_paced" src="img/product_form.png" /></div>
                            <div class="head_form_2">
                                <div class="form_content_head form_co_head_1">
                                    <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                        <?= generateHiddenFields() ?>
                                        <div class="form_container">
                                            <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                                <?= getCountryInOption() ?>
                                            </select>
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                            <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                            <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                        </div>
                                        <div class="form_container">
                                            <select class="input__inner select change-package-selector2" name="quantity">
                                                <?= getPaketiInOption() ?>
                                            </select>
                                        </div>
                                        <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                        <button class="form_btn js_submit button__text">Naruči</button>
                                    </form>
                                </div>
                                <ul class="sec_data_base sec_data_base1">
                                    <li>A személyes adatait bizalmasan kezeljük:</li>
                                </ul>
                                <img class="arrow_form" src="img/arrow.png" />
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>
                    <div class="head_form_2 new_999 dis_mob">
                        <div class="wrap_sale_1000">
                            <!-- Rasprodaja -->
                            <br>
                            <span> -50% </span>
                        </div>
                        <div class="form_content_head">
                            <div class="form_title">
                                <p class="left_t_f">
                                    A készlet mennyisége <br>
                                    korlátozott: <br>
                                </p>
                                <p class="right_t_f"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                <div class="clear"></div>
                            </div>
                            <div class="form_price">
                                <ul class="price">
                                    <li class="price_1">
                                        Puna cijena: <br>
                                        <br>
                                        <span class="bold_s_28"><span class="old-priceValue"><?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?></span><span class="x_currency"> </span></span>
                                    </li>
                                    <li class="price_2">
                                        Snižena cijena: <br>
                                        <span class="bold_s_28"><span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span><span class="x_currency"> </span></span>
                                    </li>
                                </ul>
                            </div>
                            <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                <?= generateHiddenFields() ?>
                                <div class="form_container">
                                    <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                        <?= getCountryInOption() ?>

                                    </select>
                                </div>
                                <div class="form_container">
                                    <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                    <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                </div>
                                <div class="form_container">
                                    <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                    <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                </div>
                                <div class="form_container">
                                    <select class="input__inner select change-package-selector2" name="quantity">
                                        <?= getPaketiInOption() ?>
                                    </select>
                                </div>
                                <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                <button class="form_btn js_submit button__text">Naruči</button>
                            </form>
                        </div>
                        <ul class="sec_data_base">
                            <li>A személyes adatait bizalmasan kezeljük:</li>
                        </ul>
                        <img class="arrow_form" src="img/arrow.png" /><img class="pacet_fomr_480" src="img/ws_pack_ht3_240.png" />
                        <div class="clear"></div>
                    </div>
                    <div class="footer-logo"></div>
                </div>
                <div class="clear d_n_48_0"></div>
            </div>
            <div class="clear d_b_48_0 opera_delete"></div>
        </section>
        <div class="popup-first">
            <div class="modal-first" onclick="$('.popup-first').css('display','none');"></div>
            <div class="mod">
                <div class="content">
                    <div class="bl_7_content">
                        <div class="head_form form_content">
                            <div class="this_form_left">
                                <div class="form_price">
                                    <div class="form_title1">
                                        <p class="left_t_f1">
                                            A készlet mennyisége <br>
                                            korlátozott: <br>
                                        </p>
                                        <p class="right_t_f1"><span class="numerok"> 18 </span><span class="sht"> komada </span></p>
                                        <div class="clear"></div>
                                    </div>
                                    <ul class="price form_price">
                                        <li class="price_1 pr_form1">
                                            Puna cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_previous new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['oldPrice']) ?> </span></span>
                                        </li>
                                        <li class="price_2 pr_form1">
                                            Snižena cijena: <br>
                                            <span class="bold_s_28 pr_form2"><span class="x_price_current new-priceValue"> <?= getPrice($countrySettings['paketi'][0]['newPrice']) ?> </span></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="paced_fomr_pac"><img class="fomr_paced" src="img/product_form.png" /></div>
                            <div class="head_form_2">
                                <div class="form_content_head form_co_head_1">
                                    <span class="input_name new_size_for_name"> Introduceți datele dvs. în formularul de mai jos: </span>
                                    <form action="<?= $actionEndPoint ?>" class="x_order_form form_top clearfix" method="POST">
                                        <?= generateHiddenFields() ?>
                                        <div class="form_container">
                                            <select class="input__inner x_client_name select" id="country_code_selector" name="country_code">
                                                <?= getCountryInOption() ?>
                                            </select>
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoje ime:</span> -->
                                            <i class="icon icon_user"></i><input class="input__inner x_client_name" name="name" placeholder="Unesite svoje ime" type="text" />
                                        </div>
                                        <div class="form_container">
                                            <!-- <span class="input_name">Unesite svoj broj telefona</span> -->
                                            <i class="icon icon_phone"></i><input class="input__inner x_client_phone only_number" name="phone" placeholder="Unesite svoj broj telefona" type="tel" />
                                        </div>
                                        <div class="form_container">
                                            <select class="input__inner select change-package-selector2" name="quantity">
                                                <?= getPaketiInOption() ?>
                                            </select>
                                        </div>
                                        <div class="1_pack item-gift" id="1" style="display: block;">1 PAKOVANJE = <span class="new-priceValue"><?= getPrice($countrySettings['paketi'][0]['newPrice']) ?></span></div>
                                        <button class="form_btn js_submit button__text">Naruči</button>
                                    </form>
                                </div>
                                <ul class="sec_data_base sec_data_base1">
                                    <li>A személyes adatait bizalmasan kezeljük:</li>
                                </ul>
                                <img class="arrow_form" src="img/arrow.png" />
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="js/slick.min.js"></script>
    <script src="js/common.js?v=1"></script>
    <script src="js/js.cookie.min.js" type="text/javascript"></script>
    <?= generateFooter() ?>
</body>

</html>